IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cajas_Movimientos]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cajas_Movimientos] 
END
GO

Create PROCEDURE [dbo].[CP_Cajas_Movimientos] 
	@Id_Periodo_Caja VARCHAR(5000) 
	,@id_Tipo_Valor Char(3)
	,@id_Moneda Char(3)
	,@Id_Centro_Costo CHAR(10) 
	,@Filtrar_Fecha TINYINT 
	,@Fecha_Desde DateTime 
	,@Fecha_Hasta DateTime
 
AS 
BEGIN
SET NOCOUNT ON
DECLARE @Sql		VARCHAR(MAX)
DECLARE @SqlSaldo	VARCHAR(MAX)
DECLARE @SqlSelect	VARCHAR(MAX)
DECLARE @SqlFrom	VARCHAR(MAX)
DECLARE @SqlWhere	VARCHAR(MAX)
DECLARE @SqlGroup	VARCHAR(MAX)
CREATE TABLE #Cajas_Mov  (
			Fecha DATETIME
			,Concepto VARCHAR(100)
			,Descripcion VARCHAR(300)
			,Cotizacion  DECIMAL(12,5)
			,Tipo VARCHAR(50)
			,Id_Trans INT
			,Renglon_Nro SMALLINT
			,Id_Centro_Costo CHAR(10)
			,Importe DECIMAL(16,2)
			,Imp_Valor DECIMAL(16,2)
			,Ingreso DECIMAL(16,2)
			,Egreso DECIMAL(16,2)
			,Saldo 	DECIMAL(16,2)
			,Id_Interno INT IDENTITY(1,1)
		)


SET @SqlSelect = 'SELECT CM.FECHA as Fecha
						,ISNULL(CO.Descripcion,CMT.Descripcion) AS Concepto
						,RTRIM(LTRIM(CM.DESCRIPCION)) + '' '' + RTRIM(LTRIM(ISNULL(C.Destinatario,''''))) as Descripcion
						,ISNULL(CASE ISNULL(T.Compromete_Trans_Fondos,0) 
							   WHEN 0 THEN C.Cotizacion
							   ELSE V.Cotizacion
							END,1)
							as Cotizacion
						,CMT.DESCRIPCION as Tipo 
						,CM.Id_Trans
						,CM.Renglon_Nro
						,ISNULL(C.Id_Centro_Costo,'''')
						,CM.Importe
						,SUM(V.Importe) as Imp_Valor
						,CASE ISNULL(T.COMPROMETE_BANKING,0) 
								WHEN 0 THEN 
									CASE SIGN(CM.Importe) WHEN 1 THEN SUM(V.Importe) ELSE 0 END 
								WHEN 1 THEN
									SUM(V.Importe)
								WHEN -1 THEN	
									0
								END
								as Ingreso 
						,CASE ISNULL(T.COMPROMETE_BANKING,0) 
								WHEN 0 THEN 
									CASE  SIGN(CM.Importe) WHEN -1 THEN SUM(V.Importe) ELSE 0 END 
								WHEN 1 THEN
									0
								WHEN -1 THEN	
									SUM(V.Importe)
								END
								as Egreso 
						, 0 AS Saldo
								'

SET @SqlFrom = 'FROM Valores_mov M LEFT OUTER JOIN CBTES C ON M.Id_Trans = C.Id_Trans 
                             LEFT OUTER JOIN CBTES_TIPOS T ON T.ID_TIPO_CBTE = C.ID_TIPO_CBTE
					 LEFT OUTER JOIN Cajas_Mov_Conceptos CMC 
							ON CMC.Id_Trans = M.Id_Trans
						      AND CMC.Item = (SELECT MIN(CMC2.Item) FROM Cajas_Mov_Conceptos CMC2 WHERE CMC2.Id_Trans = M.Id_Trans)   
					 LEFT OUTER JOIN Conceptos CO 
							ON CO.Id_Concepto = CMC.Id_Concepto
							, Valores V , CAJAS_MOV CM, CAJAS_MOV_TIPOS CMT '
----------------------------------------------------------------------------------------------------------------------
SET @SqlWhere = ' WHERE V.Id_Valor = M.Id_valor
				        AND M.Id_Periodo_Caja IN' + RTRIM(LTRIM(@Id_Periodo_Caja)) + '
						AND CM.Renglon_Nro = ISNULL(M.Renglon_Nro_Caja,0)
						AND CM.Id_Periodo_Caja = M.Id_Periodo_Caja 
						AND M.Renglon_Nro = (SELECT MAX(R.Renglon_Nro) FROM Valores_Mov R WHERE R.Id_Valor = M.Id_Valor 
													 AND R.Id_trans = M.Id_Trans
													 AND R.Id_Estado_Valor <> 9
													 AND R.Id_Estado_Valor <> 7)
						AND CM.Id_Estado_Mov_Caja = 2
						AND CM.Id_Trans = M.Id_Trans
						AND CM.Id_Periodo_Caja = M.Id_Periodo_Caja
						AND CMT.Id_Tipo_Mov_Caja = CM.Id_Tipo_Mov_Caja
						AND V.Id_Moneda = ''' + @id_MONEDA + ''''
					 
IF ISNULL(@id_Tipo_Valor,'') <> ''
BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Tipo_Val = '''+  @id_Tipo_Valor +''''
END

IF ISNULL(@Id_Centro_Costo,'') <> ''
BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_Centro_Costo = ''' + @Id_Centro_Costo +''''
END
----------------------------------------------------------------------------------------------------------------------
SET @SqlGroup = ' GROUP BY CM.FECHA
											,CM.DESCRIPCION
											,C.Destinatario
											,C.Cotizacion
											,V.Cotizacion
											,CMT.DESCRIPCION
											,CM.Id_Trans
											,CM.Renglon_Nro
											,C.Id_Centro_Costo
											,T.Compromete_Trans_Fondos
											,CM.Importe
											,T.COMPROMETE_BANKING
											,CO.Descripcion
									ORDER BY CM.FECHA,CM.ID_TRANS	
										'



IF ISNULL(@Filtrar_Fecha,0) <> 0
BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CM.FECHA < '''+ CONVERT(VARCHAR(8),@Fecha_HASTA+1,112) +''''
END

SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup 
PRINT @Sql
--EXECUTE (@Sql) 

CREATE INDEX IX_CajaMov____ ON  #Cajas_Mov (Id_Interno)

INSERT INTO #Cajas_Mov
EXEC(@sql)


DECLARE @Id_Interno INT 
DECLARE @Ing DECIMAL(16,2)
DECLARE @Egr DECIMAL(16,2)
DECLARE @Saldo DECIMAL(16,2)


SET @Saldo = 0
DECLARE Cur_Caja CURSOR FOR
	 SELECT Id_Interno,Ingreso,Egreso FROM #Cajas_Mov

OPEN Cur_Caja 
FETCH NEXT FROM Cur_Caja INTO @Id_Interno,@Ing,@Egr
WHILE @@FETCH_STATUS=0
BEGIN
	SET @Saldo = @Saldo + @Ing - @Egr
	UPDATE #Cajas_Mov SET Saldo = @Saldo WHERE Id_Interno = @Id_Interno
	FETCH NEXT FROM Cur_Caja INTO @Id_Interno,@Ing,@Egr
END
CLOSE Cur_Caja
DEALLOCATE Cur_Caja



---------------------------------------------------------------------Creo Tabla Temporal Final en Cero---------------------------------------------------------------------------
SELECT TOP 1 Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo
		     INTO #Cajas_Mov2 
			 FROM #Cajas_Mov  WHERE 1=0

IF ISNULL(@Filtrar_Fecha,0) <> 0
BEGIN
		IF ISNULL((SELECT COUNT(*) FROM #Cajas_Mov  WHERE  FECHA < @Fecha_Desde),0) = 0
		BEGIN        /*Cargo Saldo Anterior en cero*/
			INSERT INTO #Cajas_Mov2 ( Fecha           ,Concepto        ,Descripcion     ,Cotizacion      ,Tipo             ,Id_Trans   ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo)
				VALUES (CAST(@Fecha_Desde - 1 AS DATE),'Saldo Anterior','Saldo Anterior',1               ,'Saldo Anterior' ,0          ,0           ,''              ,0       ,0         ,0       ,0      ,0)
        END
		ELSE
		BEGIN        		/*Cargo Saldo Anterior*/
			INSERT INTO #Cajas_Mov2
				SELECT TOP 1 Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo
					FROM #Cajas_Mov  WHERE  FECHA < @Fecha_Desde ORDER BY Id_Interno DESC


			UPDATE #Cajas_Mov2 SET Concepto = 'Saldo Anterior', Descripcion = 'Saldo Anterior'
								 , Tipo = 'Saldo Anterior', Importe = 0,	Imp_Valor = 0, Ingreso = 0 
								 , Renglon_Nro = 0 , Id_Trans = 0
								 , Egreso = 0, Fecha = CAST(@Fecha_Desde - 1 AS DATE)
		END								  
  
		/*Cargo Datos*/
		INSERT INTO #Cajas_Mov2
			 SELECT Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo 
				FROM #Cajas_Mov WHERE  FECHA >= @Fecha_Desde
END
ELSE
BEGIN
		/*Cargo Saldo Anterior en cero*/
		INSERT INTO #Cajas_Mov2 ( Fecha           ,Concepto        ,Descripcion     ,Cotizacion      ,Tipo             ,Id_Trans   ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo)
			VALUES (CAST(@Fecha_Desde - 1 AS DATE),'Saldo Anterior','Saldo Anterior',1               ,'Saldo Anterior' ,0          ,0           ,''              ,0       ,0         ,0       ,0      ,0)

		/*Cargo Datos*/		
		INSERT INTO #Cajas_Mov2
			 SELECT Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo 
				FROM #Cajas_Mov 

END
SELECT * FROM #Cajas_Mov2
DROP TABLE #Cajas_Mov
DROP TABLE #Cajas_Mov2
END

--exec CP_Cajas_Movimientos '(6)','chp','pes','',0,'','' 





